// OperacjeNaPlikachDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OperacjeNaPlikach.h"
#include "OperacjeNaPlikachDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// COperacjeNaPlikachDlg dialog




COperacjeNaPlikachDlg::COperacjeNaPlikachDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COperacjeNaPlikachDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COperacjeNaPlikachDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(COperacjeNaPlikachDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &COperacjeNaPlikachDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


// COperacjeNaPlikachDlg message handlers

BOOL COperacjeNaPlikachDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COperacjeNaPlikachDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COperacjeNaPlikachDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL COperacjeNaPlikachDlg::OperacjaNaPliku(HWND uchwyt, LPCTSTR szZrodlo, LPCTSTR szCel, DWORD operacja, DWORD opcje)
{
	if(!PathFileExists(szZrodlo)) // Czy plik rdowy istnieje?
	{
		AfxMessageBox(L"Nie odnaleziono pliku");
		return FALSE;
	}
	
	SHFILEOPSTRUCT parametryOperacji;
	parametryOperacji.hwnd = uchwyt;
	parametryOperacji.wFunc = operacja;
	
	if (szZrodlo != L"")
		parametryOperacji.pFrom = szZrodlo;
	else 
		parametryOperacji.pFrom = NULL;
	
	if (szCel != L"") 
		parametryOperacji.pTo = szCel;
	else
	{
		parametryOperacji.pTo = NULL;
		parametryOperacji.fFlags = opcje;
		parametryOperacji.hNameMappings = NULL;
		parametryOperacji.lpszProgressTitle = NULL;
	}
	return (SHFileOperation(&parametryOperacji) == 0);
}

BOOL COperacjeNaPlikachDlg::KopiowaniePliku(HWND uchwyt, LPCTSTR szZrodlo, LPCTSTR szCel)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);

	return OperacjaNaPliku(uchwyt, lpBuffer, szCel, FO_COPY, 0);
}

BOOL COperacjeNaPlikachDlg::PrzenoszeniePliku(HWND uchwyt, LPCTSTR szZrodlo, LPCTSTR szCel)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);

	return OperacjaNaPliku(uchwyt, lpBuffer, szCel, FO_MOVE, 0);
}

BOOL COperacjeNaPlikachDlg::UsuwaniePliku(HWND uchwyt, LPCTSTR szZrodlo)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);

	return OperacjaNaPliku(uchwyt, lpBuffer, L"", FO_DELETE, 0);
}

void COperacjeNaPlikachDlg::OnBnClickedButton1()
{
	TCHAR path[MAX_PATH] = {0};
	GetModuleFileName(GetModuleHandle(NULL), path, MAX_PATH);
	KopiowaniePliku(m_hWnd, path, L"d:\\Kopia projektu.sln");
	PrzenoszeniePliku(m_hWnd, L"d:\\Kopia projektu.sln", L"d:\\Kopia pliku.xml");
	UsuwaniePliku(m_hWnd, L"d:\\Kopia pliku.xml");
}
